IF NOT EXISTS (SELECT * FROM sysobjects WHERE name='TBControleDocumentosNFe') BEGIN 
	CREATE TABLE [dbo].[TBControleDocumentosNFe](
		[Id] [bigint] IDENTITY(1,1) NOT NULL,
		[ChaveAcesso1] [bigint] NOT NULL,
		[ChaveAcesso2] [bigint] NOT NULL,
		[ChaveAcesso3] [int] NOT NULL,
		[NumeroProtocolo] [int] NOT NULL,
		[TipoAmbiente] [int] NOT NULL,
		[NumeroRps] [bigint] NOT NULL,
		[SerieRps] [nvarchar](10) NOT NULL,
		[Cnpj] [nvarchar](14) NOT NULL,
	 CONSTRAINT [PK_TBControleDocumentos] PRIMARY KEY CLUSTERED 
	(
		[Id] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]
END

IF NOT EXISTS (SELECT * FROM sysobjects WHERE name='TBProcessamentoRps') BEGIN 
	CREATE TABLE [dbo].[TBProcessamentoRps](
		[Id] [bigint] IDENTITY(1,1) NOT NULL,
		[Status] [int] NULL,
		[JobKey] [nvarchar](40) NOT NULL,
		[NumeroRps] [bigint] NOT NULL,
		[SerieRps] [nvarchar](10) NOT NULL,
		[TipoRps] [int] NOT NULL,
		[Cnpj] [nvarchar](14) NOT NULL,
		[TipoDocumento] [int] NOT NULL,
		[DocumentoOriginal] [nvarchar](max) NULL,
		[Guid] [uniqueidentifier] NOT NULL,
		[RetornoNFSe] [nvarchar](max) NULL,
		[RetornoNFe] [nvarchar](max) NULL,
		[DataProcessamento] [datetime] NOT NULL,
	 CONSTRAINT [PK_TBProcessamentoRps] PRIMARY KEY CLUSTERED 
	(
		[Id] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END

IF NOT EXISTS(SELECT TOP 1 * FROM sys.indexes WHERE name='IX_TBProcessamentoRps_Limpeza' AND object_id = OBJECT_ID('TBProcessamentoRps'))
BEGIN
CREATE INDEX IX_TBProcessamentoRps_Limpeza ON TBProcessamentoRps
	(DataProcessamento)  
	WITH (FILLFACTOR = 80);
END
GO

IF NOT EXISTS (SELECT type, name FROM sys.objects WHERE name = 'FN_SepararTextoPorCaractere')
BEGIN
	DECLARE @sql NVARCHAR(MAX);
    
	SET @sql =
N'CREATE FUNCTION dbo.FN_SepararTextoPorCaractere (@TextoASeparar NVARCHAR(MAX), @CaractereParaSeparar NVARCHAR(1))
RETURNS @ListaValores TABLE (Valor NVARCHAR (MAX))
AS
BEGIN
	DECLARE @Valor NVARCHAR(255)
	DECLARE @Posicao INT
	
	WHILE CHARINDEX(@CaractereParaSeparar, @TextoASeparar) > 0
	BEGIN
		SELECT @Posicao  = CHARINDEX(@CaractereParaSeparar, @TextoASeparar)  
		SELECT @Valor = SUBSTRING(@TextoASeparar, 1, @Posicao - 1)

		INSERT INTO @ListaValores 
		SELECT @Valor

		SELECT @TextoASeparar = SUBSTRING(@TextoASeparar, @Posicao + 1, LEN(@TextoASeparar) - @Posicao)
	END

	INSERT INTO @ListaValores
	SELECT @TextoASeparar

	RETURN
END';

    EXEC sp_executesql @sql;
END